
#include "player.h"
#include "inputKeyboard.h"
#include "modeGame.h"
#include "modeTitle.h"
#include "camera.h"
#include "renderer.h"
#include "manager.h"
#include "debugStr.h"
#include "modelManager.h"
#include "texManager.h"
#include "sceneField.h"
#include "bar.h"
#include "car.h"
#include "Wwise.h"

std::string CMainController::m_strName;

//=============================================================================
// 
//=============================================================================
void CMainController::Init(void)
{

}

//=============================================================================
// I
//=============================================================================
void CMainController::Uninit(void)
{

}

//=============================================================================
// XV
//=============================================================================
void CMainController::Update(void)
{
	// Ԃ̎擾
	CCar *pCar = CCar::GetCar(m_strName);

	// Ԃ̍XV
	pCar->Update();

	// L[{[h̎擾
	CInputKeyboard keyboard = CManager::GetKeyboard();

	// X,Zʏ̕sړ
	if (keyboard.GetPress(DIK_W)) { pCar->MoveForward(); }			// 
	else if (keyboard.GetPress(DIK_S)) { pCar->MoveBackward(); }	// 
	else { pCar->MoveFrictional(); }
	if (keyboard.GetPress(DIK_A)) { pCar->TurnRight(); }			// 
	else if (keyboard.GetPress(DIK_D)) { pCar->TurnLeft(); }		// 

#ifdef _DEBUG
	// fobO\ptHg̐
	std::vector<float> vecPos;
	D3DXVECTOR3 pos = pCar->GetPos();
	vecPos.push_back(pos.x);
	vecPos.push_back(pos.y);
	vecPos.push_back(pos.z);
	CDebugStr::Set("PLAYER_POS", vecPos);
#endif
}

//=============================================================================
// `揈
//=============================================================================
void CMainController::Draw(void)
{

}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CMainController *CMainController::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const std::string &onlyCarName)
{
	// CScene3D̐
	CMainController *pPlayer = new CMainController();
	pPlayer->Init();

	// Ԃ̍쐬
	pPlayer->m_strName = onlyCarName;
	CCar* car = CCar::Create(pos, rot, pPlayer->m_strName);

	// ǐ^񒆂ɂ΂l^̃f
	pPlayer->m_Part[0] = CSceneModel::Create(D3DXVECTOR3(0.f, 3.0f, 0.f), D3DXVECTOR3(0.f, 1.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/00_body.x");
	pPlayer->m_Part[0]->SetBasePos(D3DXVECTOR3(0.f, 0.0f, 0.f));
	pPlayer->m_Part[0]->SetBaseRot(D3DXVECTOR3(0.f, 0.0f, 0.f));
	pPlayer->m_Part[0]->SetParent(nullptr);	
	pPlayer->m_Part[1] = CSceneModel::Create(D3DXVECTOR3(0.f, 2.0f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/01_head.x");
	pPlayer->m_Part[1]->SetParent(pPlayer->m_Part[0]);
	pPlayer->m_Part[2] = CSceneModel::Create(D3DXVECTOR3(1.8f, 1.5f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/02_Lude.x");
	pPlayer->m_Part[2]->SetParent(pPlayer->m_Part[0]);
	pPlayer->m_Part[3] = CSceneModel::Create(D3DXVECTOR3(1.5f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/03_Lte.x");
	pPlayer->m_Part[3]->SetParent(pPlayer->m_Part[2]);
	pPlayer->m_Part[4] = CSceneModel::Create(D3DXVECTOR3(-1.8f, 1.5f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/04_Rude.x");
	pPlayer->m_Part[4]->SetParent(pPlayer->m_Part[0]);
	pPlayer->m_Part[5] = CSceneModel::Create(D3DXVECTOR3(-1.5f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/05_Rte.x");
	pPlayer->m_Part[5]->SetParent(pPlayer->m_Part[4]);
	pPlayer->m_Part[6] = CSceneModel::Create(D3DXVECTOR3(0.5f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/06_Lmomo.x");
	pPlayer->m_Part[6]->SetParent(pPlayer->m_Part[0]);
	pPlayer->m_Part[7] = CSceneModel::Create(D3DXVECTOR3(0.f, -1.0f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/07_Lasi.x");
	pPlayer->m_Part[7]->SetParent(pPlayer->m_Part[6]);
	pPlayer->m_Part[8] = CSceneModel::Create(D3DXVECTOR3(-0.5f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/08_Rmomo.x");
	pPlayer->m_Part[8]->SetParent(pPlayer->m_Part[0]);
	pPlayer->m_Part[9] = CSceneModel::Create(D3DXVECTOR3(0.f, -1.0f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1.f, 1.f, 1.f), "data/MODEL/siro/09_Rasi.x");
	pPlayer->m_Part[9]->SetParent(pPlayer->m_Part[8]);

#ifdef _DEBUG
	// fobO\ptHg̐
	std::vector<float> vecPos;
	D3DXVECTOR3 posDbg = car->GetPos();
	vecPos.push_back(posDbg.x);
	vecPos.push_back(posDbg.y);
	vecPos.push_back(posDbg.z);
	CDebugStr::Create(3, "PLAYER_POS", vecPos);
#endif

	return pPlayer;
}